#include <stdio.h>
#include <math.h>

#define MAXN 200000

long long x[MAXN], h[MAXN];

double rast(long long x1, long long y1, long long x2, long long y2) {
    double dx = x2 - x1;
    double dy = y2 - y1;
    return sqrt(dx*dx + dy*dy);
}

int main() {
    int n, i;
    scanf("%d", &n);

    for (i = 0; i < n; i++) scanf("%lld", &x[i]);
    for (i = 0; i < n; i++) scanf("%lld", &h[i]);

    for (i = 0; i < n; i++) {
        double najbolje = 1e18;

        if (i > 0 && h[i-1] >= h[i]) {
            double d = rast(x[i], h[i], x[i-1], h[i-1]);
            if (d < najbolje) najbolje = d;
        }

        if (i+1 < n && h[i+1] >= h[i]) {
            double d = rast(x[i], h[i], x[i+1], h[i+1]);
            if (d < najbolje) najbolje = d;
        }

        if (i > 0) {
            long long dx = x[i] - x[i-1];
            long long vis = h[i-1] + dx;
            if (vis >= h[i]) {
                double d = fabs(vis - h[i]);
                if (d < najbolje) najbolje = d;
            }
        }

        if (i+1 < n) {
            long long dx = x[i+1] - x[i];
            long long vis = h[i+1] + dx;
            if (vis >= h[i]) {
                double d = fabs(vis - h[i]);
                if (d < najbolje) najbolje = d;
            }
        }

        if (najbolje > 1e17) printf("-1\n");
        else printf("%.6f\n", najbolje);
    }

    return 0;
}